﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ReqList.ascx.cs" Inherits="BIS.BPM.Dashboard.ReqList" %>

<asp:Panel ID="pnl" runat="server" CssClass="infoPopup"> 
<table style="border-collapse:collapse;">
    <tr class="infoHeader">
        <td><div><asp:Label ID="lblHeader" runat="server" Text="Label"></asp:Label></div></td>
    </tr>
    <tr><td>
        <asp:GridView ID="dgrTasks" runat="server" AutoGenerateColumns="False" 
                GridLines="None" CellPadding="4" CellSpacing="1" BackColor="White" CssClass="grid"
            onrowdatabound="dgrTasks_RowDataBound">
            <EmptyDataTemplate>No requests</EmptyDataTemplate>
            <AlternatingRowStyle BackColor="#f3f3f3" />
            <Columns>
                <asp:TemplateField Visible="false" HeaderText="Task">
                    <ItemTemplate>
                        <asp:Label ID="lblTaskName" runat="server" Text="Label"></asp:Label>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="105px" />
                    <HeaderStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:BoundField DataField="RequestID" HeaderText="Nr" SortExpression="RequestID">
                    <ItemStyle HorizontalAlign="Left" Width="75px"/>
                    <HeaderStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:BoundField DataField="RequestedFor" HeaderText="Requested for" SortExpression="RequestedFor">
                    <ItemStyle HorizontalAlign="Left" Width="130px" />
                    <HeaderStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="Summary" SortExpression="Summary">
                    <ItemTemplate>
                        <asp:Label ID="lblSummary" runat="server" Text='<%# BIS.BPM.Dashboard.Util.Helper.TrimField(Eval("Summary").ToString(), SummaryLength) %>'></asp:Label>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="260px" />
                    <HeaderStyle HorizontalAlign="Left" />
                </asp:TemplateField>
            </Columns>
            <HeaderStyle CssClass="gridHeader" />
        </asp:GridView>
    </td></tr>
</table>
</asp:Panel>